/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device with attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements StructuredPojo, ToCopyableBuilder<Device.Builder, Device> {
    private final String deviceArn;

    private final String deviceSerialNumber;

    private final String deviceType;

    private final String deviceName;

    private final String softwareVersion;

    private final String macAddress;

    private final String roomArn;

    private final String deviceStatus;

    private Device(BuilderImpl builder) {
        this.deviceArn = builder.deviceArn;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.deviceType = builder.deviceType;
        this.deviceName = builder.deviceName;
        this.softwareVersion = builder.softwareVersion;
        this.macAddress = builder.macAddress;
        this.roomArn = builder.roomArn;
        this.deviceStatus = builder.deviceStatus;
    }

    /**
     * <p>
     * The ARN of a device.
     * </p>
     * 
     * @return The ARN of a device.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The serial number of a device.
     * </p>
     * 
     * @return The serial number of a device.
     */
    public String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The type of a device.
     * </p>
     * 
     * @return The type of a device.
     */
    public String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * The name of a device.
     * </p>
     * 
     * @return The name of a device.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The software version of a device.
     * </p>
     * 
     * @return The software version of a device.
     */
    public String softwareVersion() {
        return softwareVersion;
    }

    /**
     * <p>
     * The MAC address of a device.
     * </p>
     * 
     * @return The MAC address of a device.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The room ARN of a device.
     * </p>
     * 
     * @return The room ARN of a device.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device.
     * @see DeviceStatus
     */
    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device.
     * @see DeviceStatus
     */
    public String deviceStatusAsString() {
        return deviceStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceSerialNumber(), other.deviceSerialNumber())
                && Objects.equals(deviceType(), other.deviceType()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(softwareVersion(), other.softwareVersion()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(roomArn(), other.roomArn())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Device").add("DeviceArn", deviceArn()).add("DeviceSerialNumber", deviceSerialNumber())
                .add("DeviceType", deviceType()).add("DeviceName", deviceName()).add("SoftwareVersion", softwareVersion())
                .add("MacAddress", macAddress()).add("RoomArn", roomArn()).add("DeviceStatus", deviceStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "SoftwareVersion":
            return Optional.ofNullable(clazz.cast(softwareVersion()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "DeviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The ARN of a device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The serial number of a device.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The serial number of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The type of a device.
         * </p>
         * 
         * @param deviceType
         *        The type of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The name of a device.
         * </p>
         * 
         * @param deviceName
         *        The name of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The software version of a device.
         * </p>
         * 
         * @param softwareVersion
         *        The software version of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareVersion(String softwareVersion);

        /**
         * <p>
         * The MAC address of a device.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The room ARN of a device.
         * </p>
         * 
         * @param roomArn
         *        The room ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The status of a device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of a device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);
    }

    static final class BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceSerialNumber;

        private String deviceType;

        private String deviceName;

        private String softwareVersion;

        private String macAddress;

        private String roomArn;

        private String deviceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            deviceArn(model.deviceArn);
            deviceSerialNumber(model.deviceSerialNumber);
            deviceType(model.deviceType);
            deviceName(model.deviceName);
            softwareVersion(model.softwareVersion);
            macAddress(model.macAddress);
            roomArn(model.roomArn);
            deviceStatus(model.deviceStatus);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getSoftwareVersion() {
            return softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        @Override
        public Device build() {
            return new Device(this);
        }
    }
}
