/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateDeviceFromRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DisassociateDeviceFromRoomRequest.Builder, DisassociateDeviceFromRoomRequest> {
    private final String deviceArn;

    private DisassociateDeviceFromRoomRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
    }

    /**
     * <p>
     * The ARN of the device to disassociate from a room. Required.
     * </p>
     * 
     * @return The ARN of the device to disassociate from a room. Required.
     */
    public String deviceArn() {
        return deviceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateDeviceFromRoomRequest)) {
            return false;
        }
        DisassociateDeviceFromRoomRequest other = (DisassociateDeviceFromRoomRequest) obj;
        return Objects.equals(deviceArn(), other.deviceArn());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateDeviceFromRoomRequest").add("DeviceArn", deviceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, DisassociateDeviceFromRoomRequest> {
        /**
         * <p>
         * The ARN of the device to disassociate from a room. Required.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to disassociate from a room. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String deviceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateDeviceFromRoomRequest model) {
            super(model);
            deviceArn(model.deviceArn);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateDeviceFromRoomRequest build() {
            return new DisassociateDeviceFromRoomRequest(this);
        }
    }
}
