/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSkillGroupRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<GetSkillGroupRequest.Builder, GetSkillGroupRequest> {
    private final String skillGroupArn;

    private GetSkillGroupRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
    }

    /**
     * <p>
     * The ARN of the skill group for which to get details. Required.
     * </p>
     * 
     * @return The ARN of the skill group for which to get details. Required.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSkillGroupRequest)) {
            return false;
        }
        GetSkillGroupRequest other = (GetSkillGroupRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSkillGroupRequest").add("SkillGroupArn", skillGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, GetSkillGroupRequest> {
        /**
         * <p>
         * The ARN of the skill group for which to get details. Required.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group for which to get details. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSkillGroupRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSkillGroupRequest build() {
            return new GetSkillGroupRequest(this);
        }
    }
}
