/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSkillGroupResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetSkillGroupResponse.Builder, GetSkillGroupResponse> {
    private final SkillGroup skillGroup;

    private GetSkillGroupResponse(BuilderImpl builder) {
        super(builder);
        this.skillGroup = builder.skillGroup;
    }

    /**
     * <p>
     * The details of the skill group requested. Required.
     * </p>
     * 
     * @return The details of the skill group requested. Required.
     */
    public SkillGroup skillGroup() {
        return skillGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSkillGroupResponse)) {
            return false;
        }
        GetSkillGroupResponse other = (GetSkillGroupResponse) obj;
        return Objects.equals(skillGroup(), other.skillGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSkillGroupResponse").add("SkillGroup", skillGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroup":
            return Optional.ofNullable(clazz.cast(skillGroup()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, GetSkillGroupResponse> {
        /**
         * <p>
         * The details of the skill group requested. Required.
         * </p>
         * 
         * @param skillGroup
         *        The details of the skill group requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroup(SkillGroup skillGroup);

        /**
         * <p>
         * The details of the skill group requested. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link SkillGroup.Builder} avoiding the need to create
         * one manually via {@link SkillGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link SkillGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #skillGroup(SkillGroup)}.
         * 
         * @param skillGroup
         *        a consumer that will call methods on {@link SkillGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillGroup(SkillGroup)
         */
        default Builder skillGroup(Consumer<SkillGroup.Builder> skillGroup) {
            return skillGroup(SkillGroup.builder().applyMutation(skillGroup).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private SkillGroup skillGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSkillGroupResponse model) {
            super(model);
            skillGroup(model.skillGroup);
        }

        public final SkillGroup.Builder getSkillGroup() {
            return skillGroup != null ? skillGroup.toBuilder() : null;
        }

        @Override
        public final Builder skillGroup(SkillGroup skillGroup) {
            this.skillGroup = skillGroup;
            return this;
        }

        public final void setSkillGroup(SkillGroup.BuilderImpl skillGroup) {
            this.skillGroup = skillGroup != null ? skillGroup.build() : null;
        }

        @Override
        public GetSkillGroupResponse build() {
            return new GetSkillGroupResponse(this);
        }
    }
}
