/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRoomSkillParameterRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<PutRoomSkillParameterRequest.Builder, PutRoomSkillParameterRequest> {
    private final String roomArn;

    private final String skillId;

    private final RoomSkillParameter roomSkillParameter;

    private PutRoomSkillParameterRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.skillId = builder.skillId;
        this.roomSkillParameter = builder.roomSkillParameter;
    }

    /**
     * <p>
     * The ARN of the room associated with the room skill parameter. Required.
     * </p>
     * 
     * @return The ARN of the room associated with the room skill parameter. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The ARN of the skill associated with the room skill parameter. Required.
     * </p>
     * 
     * @return The ARN of the skill associated with the room skill parameter. Required.
     */
    public String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The updated room skill parameter. Required.
     * </p>
     * 
     * @return The updated room skill parameter. Required.
     */
    public RoomSkillParameter roomSkillParameter() {
        return roomSkillParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(roomSkillParameter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRoomSkillParameterRequest)) {
            return false;
        }
        PutRoomSkillParameterRequest other = (PutRoomSkillParameterRequest) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(skillId(), other.skillId())
                && Objects.equals(roomSkillParameter(), other.roomSkillParameter());
    }

    @Override
    public String toString() {
        return ToString.builder("PutRoomSkillParameterRequest").add("RoomArn", roomArn()).add("SkillId", skillId())
                .add("RoomSkillParameter", roomSkillParameter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        case "RoomSkillParameter":
            return Optional.ofNullable(clazz.cast(roomSkillParameter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, PutRoomSkillParameterRequest> {
        /**
         * <p>
         * The ARN of the room associated with the room skill parameter. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room associated with the room skill parameter. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The ARN of the skill associated with the room skill parameter. Required.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill associated with the room skill parameter. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The updated room skill parameter. Required.
         * </p>
         * 
         * @param roomSkillParameter
         *        The updated room skill parameter. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameter(RoomSkillParameter roomSkillParameter);

        /**
         * <p>
         * The updated room skill parameter. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link RoomSkillParameter.Builder} avoiding the need to
         * create one manually via {@link RoomSkillParameter#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoomSkillParameter.Builder#build()} is called immediately and its
         * result is passed to {@link #roomSkillParameter(RoomSkillParameter)}.
         * 
         * @param roomSkillParameter
         *        a consumer that will call methods on {@link RoomSkillParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomSkillParameter(RoomSkillParameter)
         */
        default Builder roomSkillParameter(Consumer<RoomSkillParameter.Builder> roomSkillParameter) {
            return roomSkillParameter(RoomSkillParameter.builder().applyMutation(roomSkillParameter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomArn;

        private String skillId;

        private RoomSkillParameter roomSkillParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRoomSkillParameterRequest model) {
            super(model);
            roomArn(model.roomArn);
            skillId(model.skillId);
            roomSkillParameter(model.roomSkillParameter);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final RoomSkillParameter.Builder getRoomSkillParameter() {
            return roomSkillParameter != null ? roomSkillParameter.toBuilder() : null;
        }

        @Override
        public final Builder roomSkillParameter(RoomSkillParameter roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter;
            return this;
        }

        public final void setRoomSkillParameter(RoomSkillParameter.BuilderImpl roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter != null ? roomSkillParameter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRoomSkillParameterRequest build() {
            return new PutRoomSkillParameterRequest(this);
        }
    }
}
