/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchDevicesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchDevicesResponse.Builder, SearchDevicesResponse> {
    private final List<DeviceData> devices;

    private final String nextToken;

    private final Integer totalCount;

    private SearchDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The devices that meet the specified set of filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The devices that meet the specified set of filter criteria, in sort order.
     */
    public List<DeviceData> devices() {
        return devices;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of devices returned.
     * </p>
     * 
     * @return The total number of devices returned.
     */
    public Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devices());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDevicesResponse)) {
            return false;
        }
        SearchDevicesResponse other = (SearchDevicesResponse) obj;
        return Objects.equals(devices(), other.devices()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(totalCount(), other.totalCount());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchDevicesResponse").add("Devices", devices()).add("NextToken", nextToken())
                .add("TotalCount", totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, SearchDevicesResponse> {
        /**
         * <p>
         * The devices that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param devices
         *        The devices that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceData> devices);

        /**
         * <p>
         * The devices that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param devices
         *        The devices that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceData... devices);

        /**
         * <p>
         * The devices that meet the specified set of filter criteria, in sort order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceData>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceData>.Builder#build()} is called immediately and its
         * result is passed to {@link #devices(List<DeviceData>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<DeviceData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<DeviceData>)
         */
        Builder devices(Consumer<DeviceData.Builder>... devices);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of devices returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of devices returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<DeviceData> devices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDevicesResponse model) {
            super(model);
            devices(model.devices);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final Collection<DeviceData.Builder> getDevices() {
            return devices != null ? devices.stream().map(DeviceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceData> devices) {
            this.devices = DeviceDataListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceData... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceData.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceData.BuilderImpl> devices) {
            this.devices = DeviceDataListCopier.copyFromBuilder(devices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchDevicesResponse build() {
            return new SearchDevicesResponse(this);
        }
    }
}
