/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.SkillGroupDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes of a skill group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkillGroupData implements StructuredPojo, ToCopyableBuilder<SkillGroupData.Builder, SkillGroupData> {
    private final String skillGroupArn;

    private final String skillGroupName;

    private final String description;

    private SkillGroupData(BuilderImpl builder) {
        this.skillGroupArn = builder.skillGroupArn;
        this.skillGroupName = builder.skillGroupName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The skill group ARN of a skill group.
     * </p>
     * 
     * @return The skill group ARN of a skill group.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * The skill group name of a skill group.
     * </p>
     * 
     * @return The skill group name of a skill group.
     */
    public String skillGroupName() {
        return skillGroupName;
    }

    /**
     * <p>
     * The description of a skill group.
     * </p>
     * 
     * @return The description of a skill group.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillGroupData)) {
            return false;
        }
        SkillGroupData other = (SkillGroupData) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(skillGroupName(), other.skillGroupName())
                && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("SkillGroupData").add("SkillGroupArn", skillGroupArn()).add("SkillGroupName", skillGroupName())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "SkillGroupName":
            return Optional.ofNullable(clazz.cast(skillGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SkillGroupDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SkillGroupData> {
        /**
         * <p>
         * The skill group ARN of a skill group.
         * </p>
         * 
         * @param skillGroupArn
         *        The skill group ARN of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * The skill group name of a skill group.
         * </p>
         * 
         * @param skillGroupName
         *        The skill group name of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupName(String skillGroupName);

        /**
         * <p>
         * The description of a skill group.
         * </p>
         * 
         * @param description
         *        The description of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String skillGroupArn;

        private String skillGroupName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillGroupData model) {
            skillGroupArn(model.skillGroupArn);
            skillGroupName(model.skillGroupName);
            description(model.description);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getSkillGroupName() {
            return skillGroupName;
        }

        @Override
        public final Builder skillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
            return this;
        }

        public final void setSkillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public SkillGroupData build() {
            return new SkillGroupData(this);
        }
    }
}
