/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.alexaforbusiness.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Profile JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ProfileUnmarshaller implements Unmarshaller<Profile, JsonUnmarshallerContext> {

    public Profile unmarshall(JsonUnmarshallerContext context) throws Exception {
        Profile.Builder profileBuilder = Profile.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ProfileArn", targetDepth)) {
                    context.nextToken();
                    profileBuilder.profileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ProfileName", targetDepth)) {
                    context.nextToken();
                    profileBuilder.profileName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Address", targetDepth)) {
                    context.nextToken();
                    profileBuilder.address(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Timezone", targetDepth)) {
                    context.nextToken();
                    profileBuilder.timezone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DistanceUnit", targetDepth)) {
                    context.nextToken();
                    profileBuilder.distanceUnit(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TemperatureUnit", targetDepth)) {
                    context.nextToken();
                    profileBuilder.temperatureUnit(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WakeWord", targetDepth)) {
                    context.nextToken();
                    profileBuilder.wakeWord(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SetupModeDisabled", targetDepth)) {
                    context.nextToken();
                    profileBuilder.setupModeDisabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("MaxVolumeLimit", targetDepth)) {
                    context.nextToken();
                    profileBuilder.maxVolumeLimit(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("PSTNEnabled", targetDepth)) {
                    context.nextToken();
                    profileBuilder.pstnEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return profileBuilder.build();
    }

    private static final ProfileUnmarshaller INSTANCE = new ProfileUnmarshaller();

    public static ProfileUnmarshaller getInstance() {
        return INSTANCE;
    }
}
