/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateContactResponse.Builder, CreateContactResponse> {
    private final String contactArn;

    private CreateContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
    }

    /**
     * <p>
     * The ARN of the newly created address book.
     * </p>
     * 
     * @return The ARN of the newly created address book.
     */
    public String contactArn() {
        return contactArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactResponse)) {
            return false;
        }
        CreateContactResponse other = (CreateContactResponse) obj;
        return Objects.equals(contactArn(), other.contactArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateContactResponse").add("ContactArn", contactArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, CreateContactResponse> {
        /**
         * <p>
         * The ARN of the newly created address book.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the newly created address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactResponse model) {
            super(model);
            contactArn(model.contactArn);
        }

        public final String getContactArn() {
            return contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public CreateContactResponse build() {
            return new CreateContactResponse(this);
        }
    }
}
