/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProfileResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateProfileResponse.Builder, CreateProfileResponse> {
    private final String profileArn;

    private CreateProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The ARN of the newly created room profile in the response.
     * </p>
     * 
     * @return The ARN of the newly created room profile in the response.
     */
    public String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileResponse)) {
            return false;
        }
        CreateProfileResponse other = (CreateProfileResponse) obj;
        return Objects.equals(profileArn(), other.profileArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateProfileResponse").add("ProfileArn", profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, CreateProfileResponse> {
        /**
         * <p>
         * The ARN of the newly created room profile in the response.
         * </p>
         * 
         * @param profileArn
         *        The ARN of the newly created room profile in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileResponse model) {
            super(model);
            profileArn(model.profileArn);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public CreateProfileResponse build() {
            return new CreateProfileResponse(this);
        }
    }
}
