/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAddressBookRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteAddressBookRequest.Builder, DeleteAddressBookRequest> {
    private final String addressBookArn;

    private DeleteAddressBookRequest(BuilderImpl builder) {
        super(builder);
        this.addressBookArn = builder.addressBookArn;
    }

    /**
     * <p>
     * The ARN of the address book to delete.
     * </p>
     * 
     * @return The ARN of the address book to delete.
     */
    public String addressBookArn() {
        return addressBookArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressBookArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAddressBookRequest)) {
            return false;
        }
        DeleteAddressBookRequest other = (DeleteAddressBookRequest) obj;
        return Objects.equals(addressBookArn(), other.addressBookArn());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteAddressBookRequest").add("AddressBookArn", addressBookArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressBookArn":
            return Optional.ofNullable(clazz.cast(addressBookArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, DeleteAddressBookRequest> {
        /**
         * <p>
         * The ARN of the address book to delete.
         * </p>
         * 
         * @param addressBookArn
         *        The ARN of the address book to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressBookArn(String addressBookArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String addressBookArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAddressBookRequest model) {
            super(model);
            addressBookArn(model.addressBookArn);
        }

        public final String getAddressBookArn() {
            return addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAddressBookRequest build() {
            return new DeleteAddressBookRequest(this);
        }
    }
}
