/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceEventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of device events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceEvent implements StructuredPojo, ToCopyableBuilder<DeviceEvent.Builder, DeviceEvent> {
    private final String type;

    private final String value;

    private final Instant timestamp;

    private DeviceEvent(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The type of device event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of device event.
     * @see DeviceEventType
     */
    public DeviceEventType type() {
        return DeviceEventType.fromValue(type);
    }

    /**
     * <p>
     * The type of device event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of device event.
     * @see DeviceEventType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The value of the event.
     * </p>
     * 
     * @return The value of the event.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The time (in epoch) when the event occurred.
     * </p>
     * 
     * @return The time (in epoch) when the event occurred.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(timestamp(), other.timestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("DeviceEvent").add("Type", typeAsString()).add("Value", value()).add("Timestamp", timestamp())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeviceEvent> {
        /**
         * <p>
         * The type of device event.
         * </p>
         * 
         * @param type
         *        The type of device event.
         * @see DeviceEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceEventType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of device event.
         * </p>
         * 
         * @param type
         *        The type of device event.
         * @see DeviceEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceEventType
         */
        Builder type(DeviceEventType type);

        /**
         * <p>
         * The value of the event.
         * </p>
         * 
         * @param value
         *        The value of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The time (in epoch) when the event occurred.
         * </p>
         * 
         * @param timestamp
         *        The time (in epoch) when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceEvent model) {
            type(model.type);
            value(model.value);
            timestamp(model.timestamp);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceEventType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public DeviceEvent build() {
            return new DeviceEvent(this);
        }
    }
}
