/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceStatusDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a device’s status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceStatusDetail implements StructuredPojo,
        ToCopyableBuilder<DeviceStatusDetail.Builder, DeviceStatusDetail> {
    private final String code;

    private DeviceStatusDetail(BuilderImpl builder) {
        this.code = builder.code;
    }

    /**
     * <p>
     * The device status detail code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link DeviceStatusDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The device status detail code.
     * @see DeviceStatusDetailCode
     */
    public DeviceStatusDetailCode code() {
        return DeviceStatusDetailCode.fromValue(code);
    }

    /**
     * <p>
     * The device status detail code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link DeviceStatusDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The device status detail code.
     * @see DeviceStatusDetailCode
     */
    public String codeAsString() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusDetail)) {
            return false;
        }
        DeviceStatusDetail other = (DeviceStatusDetail) obj;
        return Objects.equals(codeAsString(), other.codeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DeviceStatusDetail").add("Code", codeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceStatusDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeviceStatusDetail> {
        /**
         * <p>
         * The device status detail code.
         * </p>
         * 
         * @param code
         *        The device status detail code.
         * @see DeviceStatusDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatusDetailCode
         */
        Builder code(String code);

        /**
         * <p>
         * The device status detail code.
         * </p>
         * 
         * @param code
         *        The device status detail code.
         * @see DeviceStatusDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatusDetailCode
         */
        Builder code(DeviceStatusDetailCode code);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusDetail model) {
            code(model.code);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(DeviceStatusDetailCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public DeviceStatusDetail build() {
            return new DeviceStatusDetail(this);
        }
    }
}
