/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceStatusInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a device's status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceStatusInfo implements StructuredPojo, ToCopyableBuilder<DeviceStatusInfo.Builder, DeviceStatusInfo> {
    private final List<DeviceStatusDetail> deviceStatusDetails;

    private final String connectionStatus;

    private DeviceStatusInfo(BuilderImpl builder) {
        this.deviceStatusDetails = builder.deviceStatusDetails;
        this.connectionStatus = builder.connectionStatus;
    }

    /**
     * <p>
     * One or more device status detail descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more device status detail descriptions.
     */
    public List<DeviceStatusDetail> deviceStatusDetails() {
        return deviceStatusDetails;
    }

    /**
     * <p>
     * The latest available information about the connection status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The latest available information about the connection status of a device.
     * @see ConnectionStatus
     */
    public ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The latest available information about the connection status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The latest available information about the connection status of a device.
     * @see ConnectionStatus
     */
    public String connectionStatusAsString() {
        return connectionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusInfo)) {
            return false;
        }
        DeviceStatusInfo other = (DeviceStatusInfo) obj;
        return Objects.equals(deviceStatusDetails(), other.deviceStatusDetails())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DeviceStatusInfo").add("DeviceStatusDetails", deviceStatusDetails())
                .add("ConnectionStatus", connectionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceStatusDetails":
            return Optional.ofNullable(clazz.cast(deviceStatusDetails()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceStatusInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeviceStatusInfo> {
        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * 
         * @param deviceStatusDetails
         *        One or more device status detail descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails);

        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * 
         * @param deviceStatusDetails
         *        One or more device status detail descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusDetails(DeviceStatusDetail... deviceStatusDetails);

        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceStatusDetail>.Builder} avoiding the
         * need to create one manually via {@link List<DeviceStatusDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceStatusDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceStatusDetails(List<DeviceStatusDetail>)}.
         * 
         * @param deviceStatusDetails
         *        a consumer that will call methods on {@link List<DeviceStatusDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceStatusDetails(List<DeviceStatusDetail>)
         */
        Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder>... deviceStatusDetails);

        /**
         * <p>
         * The latest available information about the connection status of a device.
         * </p>
         * 
         * @param connectionStatus
         *        The latest available information about the connection status of a device.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The latest available information about the connection status of a device.
         * </p>
         * 
         * @param connectionStatus
         *        The latest available information about the connection status of a device.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(ConnectionStatus connectionStatus);
    }

    static final class BuilderImpl implements Builder {
        private List<DeviceStatusDetail> deviceStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private String connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusInfo model) {
            deviceStatusDetails(model.deviceStatusDetails);
            connectionStatus(model.connectionStatus);
        }

        public final Collection<DeviceStatusDetail.Builder> getDeviceStatusDetails() {
            return deviceStatusDetails != null ? deviceStatusDetails.stream().map(DeviceStatusDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copy(deviceStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(DeviceStatusDetail... deviceStatusDetails) {
            deviceStatusDetails(Arrays.asList(deviceStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder>... deviceStatusDetails) {
            deviceStatusDetails(Stream.of(deviceStatusDetails).map(c -> DeviceStatusDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceStatusDetails(Collection<DeviceStatusDetail.BuilderImpl> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copyFromBuilder(deviceStatusDetails);
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus.toString());
            return this;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public DeviceStatusInfo build() {
            return new DeviceStatusInfo(this);
        }
    }
}
