/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateContactFromAddressBookRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DisassociateContactFromAddressBookRequest.Builder, DisassociateContactFromAddressBookRequest> {
    private final String contactArn;

    private final String addressBookArn;

    private DisassociateContactFromAddressBookRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.addressBookArn = builder.addressBookArn;
    }

    /**
     * <p>
     * The ARN of the contact to disassociate from an address book.
     * </p>
     * 
     * @return The ARN of the contact to disassociate from an address book.
     */
    public String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The ARN of the address from which to disassociate the contact.
     * </p>
     * 
     * @return The ARN of the address from which to disassociate the contact.
     */
    public String addressBookArn() {
        return addressBookArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(addressBookArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateContactFromAddressBookRequest)) {
            return false;
        }
        DisassociateContactFromAddressBookRequest other = (DisassociateContactFromAddressBookRequest) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(addressBookArn(), other.addressBookArn());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateContactFromAddressBookRequest").add("ContactArn", contactArn())
                .add("AddressBookArn", addressBookArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "AddressBookArn":
            return Optional.ofNullable(clazz.cast(addressBookArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder,
            CopyableBuilder<Builder, DisassociateContactFromAddressBookRequest> {
        /**
         * <p>
         * The ARN of the contact to disassociate from an address book.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact to disassociate from an address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The ARN of the address from which to disassociate the contact.
         * </p>
         * 
         * @param addressBookArn
         *        The ARN of the address from which to disassociate the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressBookArn(String addressBookArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String contactArn;

        private String addressBookArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateContactFromAddressBookRequest model) {
            super(model);
            contactArn(model.contactArn);
            addressBookArn(model.addressBookArn);
        }

        public final String getContactArn() {
            return contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getAddressBookArn() {
            return addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateContactFromAddressBookRequest build() {
            return new DisassociateContactFromAddressBookRequest(this);
        }
    }
}
