/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateSkillGroupFromRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DisassociateSkillGroupFromRoomRequest.Builder, DisassociateSkillGroupFromRoomRequest> {
    private final String skillGroupArn;

    private final String roomArn;

    private DisassociateSkillGroupFromRoomRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.roomArn = builder.roomArn;
    }

    /**
     * <p>
     * The ARN of the skill group to disassociate from a room. Required.
     * </p>
     * 
     * @return The ARN of the skill group to disassociate from a room. Required.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * The ARN of the room from which the skill group is to be disassociated. Required.
     * </p>
     * 
     * @return The ARN of the room from which the skill group is to be disassociated. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSkillGroupFromRoomRequest)) {
            return false;
        }
        DisassociateSkillGroupFromRoomRequest other = (DisassociateSkillGroupFromRoomRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(roomArn(), other.roomArn());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateSkillGroupFromRoomRequest").add("SkillGroupArn", skillGroupArn())
                .add("RoomArn", roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder,
            CopyableBuilder<Builder, DisassociateSkillGroupFromRoomRequest> {
        /**
         * <p>
         * The ARN of the skill group to disassociate from a room. Required.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group to disassociate from a room. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * The ARN of the room from which the skill group is to be disassociated. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room from which the skill group is to be disassociated. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSkillGroupFromRoomRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
            roomArn(model.roomArn);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateSkillGroupFromRoomRequest build() {
            return new DisassociateSkillGroupFromRoomRequest(this);
        }
    }
}
