/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAddressBookResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetAddressBookResponse.Builder, GetAddressBookResponse> {
    private final AddressBook addressBook;

    private GetAddressBookResponse(BuilderImpl builder) {
        super(builder);
        this.addressBook = builder.addressBook;
    }

    /**
     * <p>
     * The details of the requested address book.
     * </p>
     * 
     * @return The details of the requested address book.
     */
    public AddressBook addressBook() {
        return addressBook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressBook());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAddressBookResponse)) {
            return false;
        }
        GetAddressBookResponse other = (GetAddressBookResponse) obj;
        return Objects.equals(addressBook(), other.addressBook());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAddressBookResponse").add("AddressBook", addressBook()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressBook":
            return Optional.ofNullable(clazz.cast(addressBook()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, GetAddressBookResponse> {
        /**
         * <p>
         * The details of the requested address book.
         * </p>
         * 
         * @param addressBook
         *        The details of the requested address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressBook(AddressBook addressBook);

        /**
         * <p>
         * The details of the requested address book.
         * </p>
         * This is a convenience that creates an instance of the {@link AddressBook.Builder} avoiding the need to create
         * one manually via {@link AddressBook#builder()}.
         *
         * When the {@link Consumer} completes, {@link AddressBook.Builder#build()} is called immediately and its result
         * is passed to {@link #addressBook(AddressBook)}.
         * 
         * @param addressBook
         *        a consumer that will call methods on {@link AddressBook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressBook(AddressBook)
         */
        default Builder addressBook(Consumer<AddressBook.Builder> addressBook) {
            return addressBook(AddressBook.builder().applyMutation(addressBook).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private AddressBook addressBook;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAddressBookResponse model) {
            super(model);
            addressBook(model.addressBook);
        }

        public final AddressBook.Builder getAddressBook() {
            return addressBook != null ? addressBook.toBuilder() : null;
        }

        @Override
        public final Builder addressBook(AddressBook addressBook) {
            this.addressBook = addressBook;
            return this;
        }

        public final void setAddressBook(AddressBook.BuilderImpl addressBook) {
            this.addressBook = addressBook != null ? addressBook.build() : null;
        }

        @Override
        public GetAddressBookResponse build() {
            return new GetAddressBookResponse(this);
        }
    }
}
