/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetContactResponse.Builder, GetContactResponse> {
    private final Contact contact;

    private GetContactResponse(BuilderImpl builder) {
        super(builder);
        this.contact = builder.contact;
    }

    /**
     * <p>
     * The details of the requested contact.
     * </p>
     * 
     * @return The details of the requested contact.
     */
    public Contact contact() {
        return contact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contact());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactResponse)) {
            return false;
        }
        GetContactResponse other = (GetContactResponse) obj;
        return Objects.equals(contact(), other.contact());
    }

    @Override
    public String toString() {
        return ToString.builder("GetContactResponse").add("Contact", contact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Contact":
            return Optional.ofNullable(clazz.cast(contact()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, GetContactResponse> {
        /**
         * <p>
         * The details of the requested contact.
         * </p>
         * 
         * @param contact
         *        The details of the requested contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contact(Contact contact);

        /**
         * <p>
         * The details of the requested contact.
         * </p>
         * This is a convenience that creates an instance of the {@link Contact.Builder} avoiding the need to create one
         * manually via {@link Contact#builder()}.
         *
         * When the {@link Consumer} completes, {@link Contact.Builder#build()} is called immediately and its result is
         * passed to {@link #contact(Contact)}.
         * 
         * @param contact
         *        a consumer that will call methods on {@link Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contact(Contact)
         */
        default Builder contact(Consumer<Contact.Builder> contact) {
            return contact(Contact.builder().applyMutation(contact).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private Contact contact;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactResponse model) {
            super(model);
            contact(model.contact);
        }

        public final Contact.Builder getContact() {
            return contact != null ? contact.toBuilder() : null;
        }

        @Override
        public final Builder contact(Contact contact) {
            this.contact = contact;
            return this;
        }

        public final void setContact(Contact.BuilderImpl contact) {
            this.contact = contact != null ? contact.build() : null;
        }

        @Override
        public GetContactResponse build() {
            return new GetContactResponse(this);
        }
    }
}
