/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetProfileResponse.Builder, GetProfileResponse> {
    private final Profile profile;

    private GetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profile = builder.profile;
    }

    /**
     * <p>
     * The details of the room profile requested. Required.
     * </p>
     * 
     * @return The details of the room profile requested. Required.
     */
    public Profile profile() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileResponse)) {
            return false;
        }
        GetProfileResponse other = (GetProfileResponse) obj;
        return Objects.equals(profile(), other.profile());
    }

    @Override
    public String toString() {
        return ToString.builder("GetProfileResponse").add("Profile", profile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profile":
            return Optional.ofNullable(clazz.cast(profile()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, GetProfileResponse> {
        /**
         * <p>
         * The details of the room profile requested. Required.
         * </p>
         * 
         * @param profile
         *        The details of the room profile requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(Profile profile);

        /**
         * <p>
         * The details of the room profile requested. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link Profile.Builder} avoiding the need to create one
         * manually via {@link Profile#builder()}.
         *
         * When the {@link Consumer} completes, {@link Profile.Builder#build()} is called immediately and its result is
         * passed to {@link #profile(Profile)}.
         * 
         * @param profile
         *        a consumer that will call methods on {@link Profile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profile(Profile)
         */
        default Builder profile(Consumer<Profile.Builder> profile) {
            return profile(Profile.builder().applyMutation(profile).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private Profile profile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileResponse model) {
            super(model);
            profile(model.profile);
        }

        public final Profile.Builder getProfile() {
            return profile != null ? profile.toBuilder() : null;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile = profile;
            return this;
        }

        public final void setProfile(Profile.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public GetProfileResponse build() {
            return new GetProfileResponse(this);
        }
    }
}
