/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSkillsRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ListSkillsRequest.Builder, ListSkillsRequest> {
    private final String skillGroupArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListSkillsRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ARN of the skill group for which to list enabled skills. Required.
     * </p>
     * 
     * @return The ARN of the skill group for which to list enabled skills. Required.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * <code>MaxResults</code>. Required.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by <code>MaxResults</code>. Required.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved. Required.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved. Required.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsRequest)) {
            return false;
        }
        ListSkillsRequest other = (ListSkillsRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSkillsRequest").add("SkillGroupArn", skillGroupArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, ListSkillsRequest> {
        /**
         * <p>
         * The ARN of the skill group for which to list enabled skills. Required.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group for which to list enabled skills. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by <code>MaxResults</code>. Required.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by <code>MaxResults</code>. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved. Required.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSkillsRequest build() {
            return new ListSkillsRequest(this);
        }
    }
}
