/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveRoomResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ResolveRoomResponse.Builder, ResolveRoomResponse> {
    private final String roomArn;

    private final String roomName;

    private final List<RoomSkillParameter> roomSkillParameters;

    private ResolveRoomResponse(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.roomSkillParameters = builder.roomSkillParameters;
    }

    /**
     * <p>
     * The ARN of the room from which the skill request was invoked.
     * </p>
     * 
     * @return The ARN of the room from which the skill request was invoked.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The name of the room from which the skill request was invoked.
     * </p>
     * 
     * @return The name of the room from which the skill request was invoked.
     */
    public String roomName() {
        return roomName;
    }

    /**
     * <p>
     * Response to get the room profile request. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Response to get the room profile request. Required.
     */
    public List<RoomSkillParameter> roomSkillParameters() {
        return roomSkillParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(roomSkillParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomResponse)) {
            return false;
        }
        ResolveRoomResponse other = (ResolveRoomResponse) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(roomName(), other.roomName())
                && Objects.equals(roomSkillParameters(), other.roomSkillParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("ResolveRoomResponse").add("RoomArn", roomArn()).add("RoomName", roomName())
                .add("RoomSkillParameters", roomSkillParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.ofNullable(clazz.cast(roomName()));
        case "RoomSkillParameters":
            return Optional.ofNullable(clazz.cast(roomSkillParameters()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, ResolveRoomResponse> {
        /**
         * <p>
         * The ARN of the room from which the skill request was invoked.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room from which the skill request was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The name of the room from which the skill request was invoked.
         * </p>
         * 
         * @param roomName
         *        The name of the room from which the skill request was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * 
         * @param roomSkillParameters
         *        Response to get the room profile request. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameters(Collection<RoomSkillParameter> roomSkillParameters);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * 
         * @param roomSkillParameters
         *        Response to get the room profile request. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameters(RoomSkillParameter... roomSkillParameters);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoomSkillParameter>.Builder} avoiding the
         * need to create one manually via {@link List<RoomSkillParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoomSkillParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #roomSkillParameters(List<RoomSkillParameter>)}.
         * 
         * @param roomSkillParameters
         *        a consumer that will call methods on {@link List<RoomSkillParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomSkillParameters(List<RoomSkillParameter>)
         */
        Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder>... roomSkillParameters);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String roomArn;

        private String roomName;

        private List<RoomSkillParameter> roomSkillParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomResponse model) {
            super(model);
            roomArn(model.roomArn);
            roomName(model.roomName);
            roomSkillParameters(model.roomSkillParameters);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final Collection<RoomSkillParameter.Builder> getRoomSkillParameters() {
            return roomSkillParameters != null ? roomSkillParameters.stream().map(RoomSkillParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roomSkillParameters(Collection<RoomSkillParameter> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copy(roomSkillParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(RoomSkillParameter... roomSkillParameters) {
            roomSkillParameters(Arrays.asList(roomSkillParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder>... roomSkillParameters) {
            roomSkillParameters(Stream.of(roomSkillParameters).map(c -> RoomSkillParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRoomSkillParameters(Collection<RoomSkillParameter.BuilderImpl> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copyFromBuilder(roomSkillParameters);
        }

        @Override
        public ResolveRoomResponse build() {
            return new ResolveRoomResponse(this);
        }
    }
}
