/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSkillGroupsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchSkillGroupsResponse.Builder, SearchSkillGroupsResponse> {
    private final List<SkillGroupData> skillGroups;

    private final String nextToken;

    private final Integer totalCount;

    private SearchSkillGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.skillGroups = builder.skillGroups;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The skill groups that meet the filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The skill groups that meet the filter criteria, in sort order.
     */
    public List<SkillGroupData> skillGroups() {
        return skillGroups;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of skill groups returned.
     * </p>
     * 
     * @return The total number of skill groups returned.
     */
    public Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSkillGroupsResponse)) {
            return false;
        }
        SearchSkillGroupsResponse other = (SearchSkillGroupsResponse) obj;
        return Objects.equals(skillGroups(), other.skillGroups()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(totalCount(), other.totalCount());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchSkillGroupsResponse").add("SkillGroups", skillGroups()).add("NextToken", nextToken())
                .add("TotalCount", totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroups":
            return Optional.ofNullable(clazz.cast(skillGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, SearchSkillGroupsResponse> {
        /**
         * <p>
         * The skill groups that meet the filter criteria, in sort order.
         * </p>
         * 
         * @param skillGroups
         *        The skill groups that meet the filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroups(Collection<SkillGroupData> skillGroups);

        /**
         * <p>
         * The skill groups that meet the filter criteria, in sort order.
         * </p>
         * 
         * @param skillGroups
         *        The skill groups that meet the filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroups(SkillGroupData... skillGroups);

        /**
         * <p>
         * The skill groups that meet the filter criteria, in sort order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SkillGroupData>.Builder} avoiding the need
         * to create one manually via {@link List<SkillGroupData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SkillGroupData>.Builder#build()} is called immediately and
         * its result is passed to {@link #skillGroups(List<SkillGroupData>)}.
         * 
         * @param skillGroups
         *        a consumer that will call methods on {@link List<SkillGroupData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillGroups(List<SkillGroupData>)
         */
        Builder skillGroups(Consumer<SkillGroupData.Builder>... skillGroups);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of skill groups returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of skill groups returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<SkillGroupData> skillGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSkillGroupsResponse model) {
            super(model);
            skillGroups(model.skillGroups);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final Collection<SkillGroupData.Builder> getSkillGroups() {
            return skillGroups != null ? skillGroups.stream().map(SkillGroupData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder skillGroups(Collection<SkillGroupData> skillGroups) {
            this.skillGroups = SkillGroupDataListCopier.copy(skillGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillGroups(SkillGroupData... skillGroups) {
            skillGroups(Arrays.asList(skillGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillGroups(Consumer<SkillGroupData.Builder>... skillGroups) {
            skillGroups(Stream.of(skillGroups).map(c -> SkillGroupData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSkillGroups(Collection<SkillGroupData.BuilderImpl> skillGroups) {
            this.skillGroups = SkillGroupDataListCopier.copyFromBuilder(skillGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchSkillGroupsResponse build() {
            return new SearchSkillGroupsResponse(this);
        }
    }
}
