/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeviceSyncRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<StartDeviceSyncRequest.Builder, StartDeviceSyncRequest> {
    private final String roomArn;

    private final String deviceArn;

    private final List<String> features;

    private StartDeviceSyncRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.deviceArn = builder.deviceArn;
        this.features = builder.features;
    }

    /**
     * <p>
     * The ARN of the room with which the device to sync is associated. Required.
     * </p>
     * 
     * @return The ARN of the room with which the device to sync is associated. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The ARN of the device to sync. Required.
     * </p>
     * 
     * @return The ARN of the device to sync. Required.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * Request structure to start the device sync. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Request structure to start the device sync. Required.
     */
    public List<Feature> features() {
        return TypeConverter.convert(features, Feature::fromValue);
    }

    /**
     * <p>
     * Request structure to start the device sync. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Request structure to start the device sync. Required.
     */
    public List<String> featuresAsStrings() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(featuresAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceSyncRequest)) {
            return false;
        }
        StartDeviceSyncRequest other = (StartDeviceSyncRequest) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(featuresAsStrings(), other.featuresAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("StartDeviceSyncRequest").add("RoomArn", roomArn()).add("DeviceArn", deviceArn())
                .add("Features", featuresAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "Features":
            return Optional.ofNullable(clazz.cast(featuresAsStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, StartDeviceSyncRequest> {
        /**
         * <p>
         * The ARN of the room with which the device to sync is associated. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room with which the device to sync is associated. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The ARN of the device to sync. Required.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(Collection<String> features);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(String... features);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<Feature> features);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Feature... features);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomArn;

        private String deviceArn;

        private List<String> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceSyncRequest model) {
            super(model);
            roomArn(model.roomArn);
            deviceArn(model.deviceArn);
            featuresWithStrings(model.features);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getFeatures() {
            return features;
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String... features) {
            featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<Feature> features) {
            this.features = FeaturesCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Feature... features) {
            features(Arrays.asList(features));
            return this;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceSyncRequest build() {
            return new StartDeviceSyncRequest(this);
        }
    }
}
