/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.UserDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information related to a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserData implements StructuredPojo, ToCopyableBuilder<UserData.Builder, UserData> {
    private final String userArn;

    private final String firstName;

    private final String lastName;

    private final String email;

    private final String enrollmentStatus;

    private final String enrollmentId;

    private UserData(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.enrollmentStatus = builder.enrollmentStatus;
        this.enrollmentId = builder.enrollmentId;
    }

    /**
     * <p>
     * The ARN of a user.
     * </p>
     * 
     * @return The ARN of a user.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The first name of a user.
     * </p>
     * 
     * @return The first name of a user.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of a user.
     * </p>
     * 
     * @return The last name of a user.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The email of a user.
     * </p>
     * 
     * @return The email of a user.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The enrollment status of a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enrollmentStatus}
     * will return {@link EnrollmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enrollmentStatusAsString}.
     * </p>
     * 
     * @return The enrollment status of a user.
     * @see EnrollmentStatus
     */
    public EnrollmentStatus enrollmentStatus() {
        return EnrollmentStatus.fromValue(enrollmentStatus);
    }

    /**
     * <p>
     * The enrollment status of a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enrollmentStatus}
     * will return {@link EnrollmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enrollmentStatusAsString}.
     * </p>
     * 
     * @return The enrollment status of a user.
     * @see EnrollmentStatus
     */
    public String enrollmentStatusAsString() {
        return enrollmentStatus;
    }

    /**
     * <p>
     * The enrollment ARN of a user.
     * </p>
     * 
     * @return The enrollment ARN of a user.
     */
    public String enrollmentId() {
        return enrollmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(email(), other.email())
                && Objects.equals(enrollmentStatusAsString(), other.enrollmentStatusAsString())
                && Objects.equals(enrollmentId(), other.enrollmentId());
    }

    @Override
    public String toString() {
        return ToString.builder("UserData").add("UserArn", userArn()).add("FirstName", firstName()).add("LastName", lastName())
                .add("Email", email()).add("EnrollmentStatus", enrollmentStatusAsString()).add("EnrollmentId", enrollmentId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "EnrollmentStatus":
            return Optional.ofNullable(clazz.cast(enrollmentStatusAsString()));
        case "EnrollmentId":
            return Optional.ofNullable(clazz.cast(enrollmentId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UserData> {
        /**
         * <p>
         * The ARN of a user.
         * </p>
         * 
         * @param userArn
         *        The ARN of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The first name of a user.
         * </p>
         * 
         * @param firstName
         *        The first name of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of a user.
         * </p>
         * 
         * @param lastName
         *        The last name of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The email of a user.
         * </p>
         * 
         * @param email
         *        The email of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The enrollment status of a user.
         * </p>
         * 
         * @param enrollmentStatus
         *        The enrollment status of a user.
         * @see EnrollmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnrollmentStatus
         */
        Builder enrollmentStatus(String enrollmentStatus);

        /**
         * <p>
         * The enrollment status of a user.
         * </p>
         * 
         * @param enrollmentStatus
         *        The enrollment status of a user.
         * @see EnrollmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnrollmentStatus
         */
        Builder enrollmentStatus(EnrollmentStatus enrollmentStatus);

        /**
         * <p>
         * The enrollment ARN of a user.
         * </p>
         * 
         * @param enrollmentId
         *        The enrollment ARN of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentId(String enrollmentId);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String firstName;

        private String lastName;

        private String email;

        private String enrollmentStatus;

        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            userArn(model.userArn);
            firstName(model.firstName);
            lastName(model.lastName);
            email(model.email);
            enrollmentStatus(model.enrollmentStatus);
            enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getEnrollmentStatus() {
            return enrollmentStatus;
        }

        @Override
        public final Builder enrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
            return this;
        }

        @Override
        public final Builder enrollmentStatus(EnrollmentStatus enrollmentStatus) {
            this.enrollmentStatus(enrollmentStatus.toString());
            return this;
        }

        public final void setEnrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
        }

        public final String getEnrollmentId() {
            return enrollmentId;
        }

        @Override
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        @Override
        public UserData build() {
            return new UserData(this);
        }
    }
}
