/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AssociateSkillGroupWithRoomRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AssociateSkillGroupWithRoomRequestMarshaller implements
        Marshaller<Request<AssociateSkillGroupWithRoomRequest>, AssociateSkillGroupWithRoomRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/")
            .httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true)
            .operationIdentifier("AlexaForBusiness.AssociateSkillGroupWithRoom").serviceName("Alexa For Business").build();

    private final AwsJsonProtocolFactory protocolFactory;

    public AssociateSkillGroupWithRoomRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AssociateSkillGroupWithRoomRequest> marshall(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) {
        Validate.paramNotNull(associateSkillGroupWithRoomRequest, "associateSkillGroupWithRoomRequest");
        try {
            ProtocolRequestMarshaller<AssociateSkillGroupWithRoomRequest> protocolMarshaller = protocolFactory
                    .createProtocolMarshaller(SDK_OPERATION_BINDING, associateSkillGroupWithRoomRequest);
            protocolMarshaller.startMarshalling();
            AssociateSkillGroupWithRoomRequestModelMarshaller.getInstance().marshall(associateSkillGroupWithRoomRequest,
                    protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
