/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.alexaforbusiness.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeviceData JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeviceDataUnmarshaller implements Unmarshaller<DeviceData, JsonUnmarshallerContext> {

    public DeviceData unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeviceData.Builder deviceDataBuilder = DeviceData.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DeviceArn", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceSerialNumber", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceSerialNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceType", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceName", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SoftwareVersion", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.softwareVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MacAddress", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.macAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceStatus", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RoomArn", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.roomArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RoomName", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.roomName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceStatusInfo", targetDepth)) {
                    context.nextToken();
                    deviceDataBuilder.deviceStatusInfo(DeviceStatusInfoUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deviceDataBuilder.build();
    }

    private static final DeviceDataUnmarshaller INSTANCE = new DeviceDataUnmarshaller();

    public static DeviceDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}
