/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.AddressBookMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressBook
implements StructuredPojo,
ToCopyableBuilder<Builder, AddressBook> {
    private final String addressBookArn;
    private final String name;
    private final String description;

    private AddressBook(BuilderImpl builder) {
        this.addressBookArn = builder.addressBookArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String addressBookArn() {
        return this.addressBookArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressBookArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressBook)) {
            return false;
        }
        AddressBook other = (AddressBook)obj;
        return Objects.equals(this.addressBookArn(), other.addressBookArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"AddressBook").add("AddressBookArn", (Object)this.addressBookArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressBookArn": {
                return Optional.ofNullable(clazz.cast(this.addressBookArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddressBookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressBookArn;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressBook model) {
            this.addressBookArn(model.addressBookArn);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getAddressBookArn() {
            return this.addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public AddressBook build() {
            return new AddressBook(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddressBook> {
        public Builder addressBookArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

