/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateContactWithAddressBookRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, AssociateContactWithAddressBookRequest> {
    private final String contactArn;
    private final String addressBookArn;

    private AssociateContactWithAddressBookRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.addressBookArn = builder.addressBookArn;
    }

    public String contactArn() {
        return this.contactArn;
    }

    public String addressBookArn() {
        return this.addressBookArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressBookArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateContactWithAddressBookRequest)) {
            return false;
        }
        AssociateContactWithAddressBookRequest other = (AssociateContactWithAddressBookRequest)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.addressBookArn(), other.addressBookArn());
    }

    public String toString() {
        return ToString.builder((String)"AssociateContactWithAddressBookRequest").add("ContactArn", (Object)this.contactArn()).add("AddressBookArn", (Object)this.addressBookArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "AddressBookArn": {
                return Optional.ofNullable(clazz.cast(this.addressBookArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String contactArn;
        private String addressBookArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateContactWithAddressBookRequest model) {
            super(model);
            this.contactArn(model.contactArn);
            this.addressBookArn(model.addressBookArn);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getAddressBookArn() {
            return this.addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateContactWithAddressBookRequest build() {
            return new AssociateContactWithAddressBookRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, AssociateContactWithAddressBookRequest> {
        public Builder contactArn(String var1);

        public Builder addressBookArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

