/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateDeviceWithRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, AssociateDeviceWithRoomRequest> {
    private final String deviceArn;
    private final String roomArn;

    private AssociateDeviceWithRoomRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.roomArn = builder.roomArn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String roomArn() {
        return this.roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDeviceWithRoomRequest)) {
            return false;
        }
        AssociateDeviceWithRoomRequest other = (AssociateDeviceWithRoomRequest)((Object)obj);
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.roomArn(), other.roomArn());
    }

    public String toString() {
        return ToString.builder((String)"AssociateDeviceWithRoomRequest").add("DeviceArn", (Object)this.deviceArn()).add("RoomArn", (Object)this.roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String deviceArn;
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDeviceWithRoomRequest model) {
            super(model);
            this.deviceArn(model.deviceArn);
            this.roomArn(model.roomArn);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDeviceWithRoomRequest build() {
            return new AssociateDeviceWithRoomRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, AssociateDeviceWithRoomRequest> {
        public Builder deviceArn(String var1);

        public Builder roomArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

