/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceData
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceData> {
    private final String deviceArn;
    private final String deviceSerialNumber;
    private final String deviceType;
    private final String deviceName;
    private final String softwareVersion;
    private final String macAddress;
    private final String deviceStatus;
    private final String roomArn;
    private final String roomName;
    private final DeviceStatusInfo deviceStatusInfo;

    private DeviceData(BuilderImpl builder) {
        this.deviceArn = builder.deviceArn;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.deviceType = builder.deviceType;
        this.deviceName = builder.deviceName;
        this.softwareVersion = builder.softwareVersion;
        this.macAddress = builder.macAddress;
        this.deviceStatus = builder.deviceStatus;
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.deviceStatusInfo = builder.deviceStatusInfo;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String deviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String deviceType() {
        return this.deviceType;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(this.deviceStatus);
    }

    public String deviceStatusAsString() {
        return this.deviceStatus;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String roomName() {
        return this.roomName;
    }

    public DeviceStatusInfo deviceStatusInfo() {
        return this.deviceStatusInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceData)) {
            return false;
        }
        DeviceData other = (DeviceData)obj;
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceSerialNumber(), other.deviceSerialNumber()) && Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.softwareVersion(), other.softwareVersion()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.deviceStatusAsString(), other.deviceStatusAsString()) && Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.deviceStatusInfo(), other.deviceStatusInfo());
    }

    public String toString() {
        return ToString.builder((String)"DeviceData").add("DeviceArn", (Object)this.deviceArn()).add("DeviceSerialNumber", (Object)this.deviceSerialNumber()).add("DeviceType", (Object)this.deviceType()).add("DeviceName", (Object)this.deviceName()).add("SoftwareVersion", (Object)this.softwareVersion()).add("MacAddress", (Object)this.macAddress()).add("DeviceStatus", (Object)this.deviceStatusAsString()).add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("DeviceStatusInfo", (Object)this.deviceStatusInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.deviceSerialNumber()));
            }
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "SoftwareVersion": {
                return Optional.ofNullable(clazz.cast(this.softwareVersion()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "DeviceStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusAsString()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "DeviceStatusInfo": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceSerialNumber;
        private String deviceType;
        private String deviceName;
        private String softwareVersion;
        private String macAddress;
        private String deviceStatus;
        private String roomArn;
        private String roomName;
        private DeviceStatusInfo deviceStatusInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceData model) {
            this.deviceArn(model.deviceArn);
            this.deviceSerialNumber(model.deviceSerialNumber);
            this.deviceType(model.deviceType);
            this.deviceName(model.deviceName);
            this.softwareVersion(model.softwareVersion);
            this.macAddress(model.macAddress);
            this.deviceStatus(model.deviceStatus);
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.deviceStatusInfo(model.deviceStatusInfo);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceSerialNumber() {
            return this.deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getSoftwareVersion() {
            return this.softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getDeviceStatus() {
            return this.deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final DeviceStatusInfo.Builder getDeviceStatusInfo() {
            return this.deviceStatusInfo != null ? this.deviceStatusInfo.toBuilder() : null;
        }

        @Override
        public final Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo;
            return this;
        }

        public final void setDeviceStatusInfo(DeviceStatusInfo.BuilderImpl deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo != null ? deviceStatusInfo.build() : null;
        }

        public DeviceData build() {
            return new DeviceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceData> {
        public Builder deviceArn(String var1);

        public Builder deviceSerialNumber(String var1);

        public Builder deviceType(String var1);

        public Builder deviceName(String var1);

        public Builder softwareVersion(String var1);

        public Builder macAddress(String var1);

        public Builder deviceStatus(String var1);

        public Builder deviceStatus(DeviceStatus var1);

        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder deviceStatusInfo(DeviceStatusInfo var1);

        default public Builder deviceStatusInfo(Consumer<DeviceStatusInfo.Builder> deviceStatusInfo) {
            return this.deviceStatusInfo((DeviceStatusInfo)((DeviceStatusInfo.Builder)DeviceStatusInfo.builder().applyMutation(deviceStatusInfo)).build());
        }
    }
}

