/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventType;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceEventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceEvent> {
    private final String type;
    private final String value;
    private final Instant timestamp;

    private DeviceEvent(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    public DeviceEventType type() {
        return DeviceEventType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"DeviceEvent").add("Type", (Object)this.typeAsString()).add("Value", (Object)this.value()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String value;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceEvent model) {
            this.type(model.type);
            this.value(model.value);
            this.timestamp(model.timestamp);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceEventType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public DeviceEvent build() {
            return new DeviceEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceEvent> {
        public Builder type(String var1);

        public Builder type(DeviceEventType var1);

        public Builder value(String var1);

        public Builder timestamp(Instant var1);
    }
}

