/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.ConnectionStatus;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailsCopier;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeviceStatusInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceStatusInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceStatusInfo> {
    private final List<DeviceStatusDetail> deviceStatusDetails;
    private final String connectionStatus;

    private DeviceStatusInfo(BuilderImpl builder) {
        this.deviceStatusDetails = builder.deviceStatusDetails;
        this.connectionStatus = builder.connectionStatus;
    }

    public List<DeviceStatusDetail> deviceStatusDetails() {
        return this.deviceStatusDetails;
    }

    public ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(this.connectionStatus);
    }

    public String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusInfo)) {
            return false;
        }
        DeviceStatusInfo other = (DeviceStatusInfo)obj;
        return Objects.equals(this.deviceStatusDetails(), other.deviceStatusDetails()) && Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeviceStatusInfo").add("DeviceStatusDetails", this.deviceStatusDetails()).add("ConnectionStatus", (Object)this.connectionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusDetails()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceStatusInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeviceStatusDetail> deviceStatusDetails = DefaultSdkAutoConstructList.getInstance();
        private String connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusInfo model) {
            this.deviceStatusDetails(model.deviceStatusDetails);
            this.connectionStatus(model.connectionStatus);
        }

        public final Collection<DeviceStatusDetail.Builder> getDeviceStatusDetails() {
            return this.deviceStatusDetails != null ? (Collection)this.deviceStatusDetails.stream().map(DeviceStatusDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copy(deviceStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(DeviceStatusDetail ... deviceStatusDetails) {
            this.deviceStatusDetails(Arrays.asList(deviceStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder> ... deviceStatusDetails) {
            this.deviceStatusDetails(Stream.of(deviceStatusDetails).map(c -> (DeviceStatusDetail)((DeviceStatusDetail.Builder)DeviceStatusDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceStatusDetails(Collection<DeviceStatusDetail.BuilderImpl> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copyFromBuilder(deviceStatusDetails);
        }

        public final String getConnectionStatus() {
            return this.connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus.toString());
            return this;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        public DeviceStatusInfo build() {
            return new DeviceStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceStatusInfo> {
        public Builder deviceStatusDetails(Collection<DeviceStatusDetail> var1);

        public Builder deviceStatusDetails(DeviceStatusDetail ... var1);

        public Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder> ... var1);

        public Builder connectionStatus(String var1);

        public Builder connectionStatus(ConnectionStatus var1);
    }
}

