/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.WakeWord;
import software.amazon.awssdk.services.alexaforbusiness.transform.ProfileDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileData
implements StructuredPojo,
ToCopyableBuilder<Builder, ProfileData> {
    private final String profileArn;
    private final String profileName;
    private final String address;
    private final String timezone;
    private final String distanceUnit;
    private final String temperatureUnit;
    private final String wakeWord;

    private ProfileData(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
    }

    public String profileArn() {
        return this.profileArn;
    }

    public String profileName() {
        return this.profileName;
    }

    public String address() {
        return this.address;
    }

    public String timezone() {
        return this.timezone;
    }

    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(this.temperatureUnit);
    }

    public String temperatureUnitAsString() {
        return this.temperatureUnit;
    }

    public WakeWord wakeWord() {
        return WakeWord.fromValue(this.wakeWord);
    }

    public String wakeWordAsString() {
        return this.wakeWord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeWordAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileData)) {
            return false;
        }
        ProfileData other = (ProfileData)obj;
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.temperatureUnitAsString(), other.temperatureUnitAsString()) && Objects.equals(this.wakeWordAsString(), other.wakeWordAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProfileData").add("ProfileArn", (Object)this.profileArn()).add("ProfileName", (Object)this.profileName()).add("Address", (Object)this.address()).add("Timezone", (Object)this.timezone()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("TemperatureUnit", (Object)this.temperatureUnitAsString()).add("WakeWord", (Object)this.wakeWordAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "TemperatureUnit": {
                return Optional.ofNullable(clazz.cast(this.temperatureUnitAsString()));
            }
            case "WakeWord": {
                return Optional.ofNullable(clazz.cast(this.wakeWordAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileName;
        private String address;
        private String timezone;
        private String distanceUnit;
        private String temperatureUnit;
        private String wakeWord;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileData model) {
            this.profileArn(model.profileArn);
            this.profileName(model.profileName);
            this.address(model.address);
            this.timezone(model.timezone);
            this.distanceUnit(model.distanceUnit);
            this.temperatureUnit(model.temperatureUnit);
            this.wakeWord(model.wakeWord);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnit() {
            return this.temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWord() {
            return this.wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public ProfileData build() {
            return new ProfileData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProfileData> {
        public Builder profileArn(String var1);

        public Builder profileName(String var1);

        public Builder address(String var1);

        public Builder timezone(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder temperatureUnit(String var1);

        public Builder temperatureUnit(TemperatureUnit var1);

        public Builder wakeWord(String var1);

        public Builder wakeWord(WakeWord var1);
    }
}

