/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRoomSkillParameterRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, PutRoomSkillParameterRequest> {
    private final String roomArn;
    private final String skillId;
    private final RoomSkillParameter roomSkillParameter;

    private PutRoomSkillParameterRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.skillId = builder.skillId;
        this.roomSkillParameter = builder.roomSkillParameter;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String skillId() {
        return this.skillId;
    }

    public RoomSkillParameter roomSkillParameter() {
        return this.roomSkillParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomSkillParameter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRoomSkillParameterRequest)) {
            return false;
        }
        PutRoomSkillParameterRequest other = (PutRoomSkillParameterRequest)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.roomSkillParameter(), other.roomSkillParameter());
    }

    public String toString() {
        return ToString.builder((String)"PutRoomSkillParameterRequest").add("RoomArn", (Object)this.roomArn()).add("SkillId", (Object)this.skillId()).add("RoomSkillParameter", (Object)this.roomSkillParameter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "RoomSkillParameter": {
                return Optional.ofNullable(clazz.cast(this.roomSkillParameter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomArn;
        private String skillId;
        private RoomSkillParameter roomSkillParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRoomSkillParameterRequest model) {
            super(model);
            this.roomArn(model.roomArn);
            this.skillId(model.skillId);
            this.roomSkillParameter(model.roomSkillParameter);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final RoomSkillParameter.Builder getRoomSkillParameter() {
            return this.roomSkillParameter != null ? this.roomSkillParameter.toBuilder() : null;
        }

        @Override
        public final Builder roomSkillParameter(RoomSkillParameter roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter;
            return this;
        }

        public final void setRoomSkillParameter(RoomSkillParameter.BuilderImpl roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter != null ? roomSkillParameter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRoomSkillParameterRequest build() {
            return new PutRoomSkillParameterRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, PutRoomSkillParameterRequest> {
        public Builder roomArn(String var1);

        public Builder skillId(String var1);

        public Builder roomSkillParameter(RoomSkillParameter var1);

        default public Builder roomSkillParameter(Consumer<RoomSkillParameter.Builder> roomSkillParameter) {
            return this.roomSkillParameter((RoomSkillParameter)((RoomSkillParameter.Builder)RoomSkillParameter.builder().applyMutation(roomSkillParameter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

