/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.RoomMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Room
implements StructuredPojo,
ToCopyableBuilder<Builder, Room> {
    private final String roomArn;
    private final String roomName;
    private final String description;
    private final String providerCalendarId;
    private final String profileArn;

    private Room(BuilderImpl builder) {
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String roomName() {
        return this.roomName;
    }

    public String description() {
        return this.description;
    }

    public String providerCalendarId() {
        return this.providerCalendarId;
    }

    public String profileArn() {
        return this.profileArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Room)) {
            return false;
        }
        Room other = (Room)obj;
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerCalendarId(), other.providerCalendarId()) && Objects.equals(this.profileArn(), other.profileArn());
    }

    public String toString() {
        return ToString.builder((String)"Room").add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("Description", (Object)this.description()).add("ProviderCalendarId", (Object)this.providerCalendarId()).add("ProfileArn", (Object)this.profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProviderCalendarId": {
                return Optional.ofNullable(clazz.cast(this.providerCalendarId()));
            }
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoomMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roomArn;
        private String roomName;
        private String description;
        private String providerCalendarId;
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Room model) {
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.description(model.description);
            this.providerCalendarId(model.providerCalendarId);
            this.profileArn(model.profileArn);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderCalendarId() {
            return this.providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public Room build() {
            return new Room(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Room> {
        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder description(String var1);

        public Builder providerCalendarId(String var1);

        public Builder profileArn(String var1);
    }
}

