/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ProfileData;
import software.amazon.awssdk.services.alexaforbusiness.model.ProfileDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProfilesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchProfilesResponse> {
    private final List<ProfileData> profiles;
    private final String nextToken;
    private final Integer totalCount;

    private SearchProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profiles = builder.profiles;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public List<ProfileData> profiles() {
        return this.profiles;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProfilesResponse)) {
            return false;
        }
        SearchProfilesResponse other = (SearchProfilesResponse)((Object)obj);
        return Objects.equals(this.profiles(), other.profiles()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchProfilesResponse").add("Profiles", this.profiles()).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<ProfileData> profiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProfilesResponse model) {
            super(model);
            this.profiles(model.profiles);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<ProfileData.Builder> getProfiles() {
            return this.profiles != null ? (Collection)this.profiles.stream().map(ProfileData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profiles(Collection<ProfileData> profiles) {
            this.profiles = ProfileDataListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(ProfileData ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<ProfileData.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (ProfileData)((ProfileData.Builder)ProfileData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfiles(Collection<ProfileData.BuilderImpl> profiles) {
            this.profiles = ProfileDataListCopier.copyFromBuilder(profiles);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchProfilesResponse build() {
            return new SearchProfilesResponse(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    CopyableBuilder<Builder, SearchProfilesResponse> {
        public Builder profiles(Collection<ProfileData> var1);

        public Builder profiles(ProfileData ... var1);

        public Builder profiles(Consumer<ProfileData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

