/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.SkillSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkillSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, SkillSummary> {
    private final String skillId;
    private final String skillName;
    private final Boolean supportsLinking;

    private SkillSummary(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.supportsLinking = builder.supportsLinking;
    }

    public String skillId() {
        return this.skillId;
    }

    public String skillName() {
        return this.skillName;
    }

    public Boolean supportsLinking() {
        return this.supportsLinking;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillName());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLinking());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillSummary)) {
            return false;
        }
        SkillSummary other = (SkillSummary)obj;
        return Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.skillName(), other.skillName()) && Objects.equals(this.supportsLinking(), other.supportsLinking());
    }

    public String toString() {
        return ToString.builder((String)"SkillSummary").add("SkillId", (Object)this.skillId()).add("SkillName", (Object)this.skillName()).add("SupportsLinking", (Object)this.supportsLinking()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "SkillName": {
                return Optional.ofNullable(clazz.cast(this.skillName()));
            }
            case "SupportsLinking": {
                return Optional.ofNullable(clazz.cast(this.supportsLinking()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SkillSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String skillId;
        private String skillName;
        private Boolean supportsLinking;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillSummary model) {
            this.skillId(model.skillId);
            this.skillName(model.skillName);
            this.supportsLinking(model.supportsLinking);
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getSkillName() {
            return this.skillName;
        }

        @Override
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        public final Boolean getSupportsLinking() {
            return this.supportsLinking;
        }

        @Override
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        public SkillSummary build() {
            return new SkillSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SkillSummary> {
        public Builder skillId(String var1);

        public Builder skillName(String var1);

        public Builder supportsLinking(Boolean var1);
    }
}

