/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.AddressBookData;

public class AddressBookDataUnmarshaller
implements Unmarshaller<AddressBookData, JsonUnmarshallerContext> {
    private static final AddressBookDataUnmarshaller INSTANCE = new AddressBookDataUnmarshaller();

    public AddressBookData unmarshall(JsonUnmarshallerContext context) throws Exception {
        AddressBookData.Builder addressBookDataBuilder = AddressBookData.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AddressBookArn", targetDepth)) {
                    context.nextToken();
                    addressBookDataBuilder.addressBookArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    addressBookDataBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    addressBookDataBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AddressBookData)addressBookDataBuilder.build();
    }

    public static AddressBookDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

