/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> PROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileName").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final MarshallingInfo<String> DISTANCEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DistanceUnit").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPERATUREUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemperatureUnit").isBinary(false).build();
    private static final MarshallingInfo<String> WAKEWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WakeWord").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<Boolean> SETUPMODEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SetupModeDisabled").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXVOLUMELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxVolumeLimit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PSTNENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PSTNEnabled").isBinary(false).build();
    private static final CreateProfileRequestModelMarshaller INSTANCE = new CreateProfileRequestModelMarshaller();

    private CreateProfileRequestModelMarshaller() {
    }

    public static CreateProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateProfileRequest createProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createProfileRequest), (String)"createProfileRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createProfileRequest.profileName(), PROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.timezone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.distanceUnitAsString(), DISTANCEUNIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.temperatureUnitAsString(), TEMPERATUREUNIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.wakeWordAsString(), WAKEWORD_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.setupModeDisabled(), SETUPMODEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.maxVolumeLimit(), MAXVOLUMELIMIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.pstnEnabled(), PSTNENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

