/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceDataMarshaller {
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICESERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceSerialNumber").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceType").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").isBinary(false).build();
    private static final MarshallingInfo<String> SOFTWAREVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SoftwareVersion").isBinary(false).build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MacAddress").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceStatus").isBinary(false).build();
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROOMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICESTATUSINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceStatusInfo").isBinary(false).build();
    private static final DeviceDataMarshaller INSTANCE = new DeviceDataMarshaller();

    private DeviceDataMarshaller() {
    }

    public static DeviceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceData deviceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceData, (String)"deviceData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceData.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceSerialNumber(), DEVICESERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceType(), DEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)deviceData.softwareVersion(), SOFTWAREVERSION_BINDING);
            protocolMarshaller.marshall((Object)deviceData.macAddress(), MACADDRESS_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceStatusAsString(), DEVICESTATUS_BINDING);
            protocolMarshaller.marshall((Object)deviceData.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)deviceData.roomName(), ROOMNAME_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceStatusInfo(), DEVICESTATUSINFO_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

