/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceStatusInfoMarshaller {
    private static final MarshallingInfo<List> DEVICESTATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceStatusDetails").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionStatus").isBinary(false).build();
    private static final DeviceStatusInfoMarshaller INSTANCE = new DeviceStatusInfoMarshaller();

    private DeviceStatusInfoMarshaller() {
    }

    public static DeviceStatusInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceStatusInfo deviceStatusInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceStatusInfo, (String)"deviceStatusInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(deviceStatusInfo.deviceStatusDetails(), DEVICESTATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)deviceStatusInfo.connectionStatusAsString(), CONNECTIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

