/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.ProfileData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProfileDataMarshaller {
    private static final MarshallingInfo<String> PROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> PROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileName").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").isBinary(false).build();
    private static final MarshallingInfo<String> DISTANCEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DistanceUnit").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPERATUREUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemperatureUnit").isBinary(false).build();
    private static final MarshallingInfo<String> WAKEWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WakeWord").isBinary(false).build();
    private static final ProfileDataMarshaller INSTANCE = new ProfileDataMarshaller();

    private ProfileDataMarshaller() {
    }

    public static ProfileDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProfileData profileData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)profileData, (String)"profileData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)profileData.profileArn(), PROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)profileData.profileName(), PROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)profileData.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)profileData.timezone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)profileData.distanceUnitAsString(), DISTANCEUNIT_BINDING);
            protocolMarshaller.marshall((Object)profileData.temperatureUnitAsString(), TEMPERATUREUNIT_BINDING);
            protocolMarshaller.marshall((Object)profileData.wakeWordAsString(), WAKEWORD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

