/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResolveRoomRequestModelMarshaller {
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> SKILLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillId").isBinary(false).build();
    private static final ResolveRoomRequestModelMarshaller INSTANCE = new ResolveRoomRequestModelMarshaller();

    private ResolveRoomRequestModelMarshaller() {
    }

    public static ResolveRoomRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResolveRoomRequest resolveRoomRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)resolveRoomRequest), (String)"resolveRoomRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resolveRoomRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)resolveRoomRequest.skillId(), SKILLID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

