/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RevokeInvitationRequestModelMarshaller {
    private static final MarshallingInfo<String> USERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENROLLMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnrollmentId").isBinary(false).build();
    private static final RevokeInvitationRequestModelMarshaller INSTANCE = new RevokeInvitationRequestModelMarshaller();

    private RevokeInvitationRequestModelMarshaller() {
    }

    public static RevokeInvitationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RevokeInvitationRequest revokeInvitationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)revokeInvitationRequest), (String)"revokeInvitationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)revokeInvitationRequest.userArn(), USERARN_BINDING);
            protocolMarshaller.marshall((Object)revokeInvitationRequest.enrollmentId(), ENROLLMENTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

