/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RoomDataMarshaller {
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROOMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERCALENDARID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderCalendarId").isBinary(false).build();
    private static final MarshallingInfo<String> PROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> PROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileName").isBinary(false).build();
    private static final RoomDataMarshaller INSTANCE = new RoomDataMarshaller();

    private RoomDataMarshaller() {
    }

    public static RoomDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RoomData roomData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)roomData, (String)"roomData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)roomData.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)roomData.roomName(), ROOMNAME_BINDING);
            protocolMarshaller.marshall((Object)roomData.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)roomData.providerCalendarId(), PROVIDERCALENDARID_BINDING);
            protocolMarshaller.marshall((Object)roomData.profileArn(), PROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)roomData.profileName(), PROFILENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

