/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchRoomsRequestModelMarshaller {
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<List> SORTCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortCriteria").isBinary(false).build();
    private static final SearchRoomsRequestModelMarshaller INSTANCE = new SearchRoomsRequestModelMarshaller();

    private SearchRoomsRequestModelMarshaller() {
    }

    public static SearchRoomsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchRoomsRequest searchRoomsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchRoomsRequest), (String)"searchRoomsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchRoomsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)searchRoomsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall(searchRoomsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall(searchRoomsRequest.sortCriteria(), SORTCRITERIA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

