/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SkillGroupDataMarshaller {
    private static final MarshallingInfo<String> SKILLGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillGroupArn").isBinary(false).build();
    private static final MarshallingInfo<String> SKILLGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final SkillGroupDataMarshaller INSTANCE = new SkillGroupDataMarshaller();

    private SkillGroupDataMarshaller() {
    }

    public static SkillGroupDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkillGroupData skillGroupData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)skillGroupData, (String)"skillGroupData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)skillGroupData.skillGroupArn(), SKILLGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)skillGroupData.skillGroupName(), SKILLGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)skillGroupData.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

