/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SkillGroupMarshaller {
    private static final MarshallingInfo<String> SKILLGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillGroupArn").isBinary(false).build();
    private static final MarshallingInfo<String> SKILLGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final SkillGroupMarshaller INSTANCE = new SkillGroupMarshaller();

    private SkillGroupMarshaller() {
    }

    public static SkillGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkillGroup skillGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)skillGroup, (String)"skillGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)skillGroup.skillGroupArn(), SKILLGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)skillGroup.skillGroupName(), SKILLGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)skillGroup.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

