/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SkillSummaryMarshaller {
    private static final MarshallingInfo<String> SKILLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillId").isBinary(false).build();
    private static final MarshallingInfo<String> SKILLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SUPPORTSLINKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportsLinking").isBinary(false).build();
    private static final SkillSummaryMarshaller INSTANCE = new SkillSummaryMarshaller();

    private SkillSummaryMarshaller() {
    }

    public static SkillSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkillSummary skillSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)skillSummary, (String)"skillSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)skillSummary.skillId(), SKILLID_BINDING);
            protocolMarshaller.marshall((Object)skillSummary.skillName(), SKILLNAME_BINDING);
            protocolMarshaller.marshall((Object)skillSummary.supportsLinking(), SUPPORTSLINKING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

