/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartDeviceSyncRequestModelMarshaller {
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").isBinary(false).build();
    private static final MarshallingInfo<List> FEATURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Features").isBinary(false).build();
    private static final StartDeviceSyncRequestModelMarshaller INSTANCE = new StartDeviceSyncRequestModelMarshaller();

    private StartDeviceSyncRequestModelMarshaller() {
    }

    public static StartDeviceSyncRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartDeviceSyncRequest startDeviceSyncRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startDeviceSyncRequest), (String)"startDeviceSyncRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startDeviceSyncRequest.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)startDeviceSyncRequest.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall(startDeviceSyncRequest.featuresAsStrings(), FEATURES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

